#ifndef _MAINDLG_CPP
#define _MAINDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <WinSock.H>
#include <Windows.H>
#include <WindowsX.H>
#include <ShlOBJ.H>
#include <CommCtrl.H>
#include <StdIO.H>
#include <IO.H>
#include <IPHlpAPI.h>

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Debug.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/ScanDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND hMainDialog = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    if(uMsg == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
		hMainDialog = hWnd;

        HMENU SystemMenu_hMenu = GetSystemMenu(hWnd, FALSE);
        AppendMenu(SystemMenu_hMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu_hMenu, MF_STRING, MAINDIALOG_MENU_ABOUT, "About");

        SendMessage(hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)));

        HMENU MainMenu_hMenu = LoadMenu(ghAppInstance, MAKEINTRESOURCE(IDR_MAIN) );
        SetMenu(hWnd, MainMenu_hMenu);

        hStatusBar = CreateStatusWindow(WS_CHILD|WS_VISIBLE, "Scanning, Please wait...", hWnd, 1);

        hLanViewListBox = GetDlgItem(hWnd, IDC_LANLIEWLISTBOX);

        SendMessage(hLanViewListBox, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);

        ghImageList = ImageList_Create(GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), TRUE, 1, 1);

        HICON hIcon = NULL;

        hIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_NETCOMPON));
        ImageList_AddIcon(ghImageList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        hIcon = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_NETCOMPOFF));
        ImageList_AddIcon(ghImageList, (HICON)hIcon);
        DeleteObject((HICON)hIcon);

        ListView_SetImageList(hLanViewListBox, ghImageList, LVSIL_SMALL);

        LV_COLUMN MyLVColumb;
        memset(&MyLVColumb, 0, sizeof(LV_COLUMN));

        MyLVColumb.cx        = 20;
        MyLVColumb.pszText   = " ";
        MyLVColumb.iSubItem  = 0;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hLanViewListBox, 0, &MyLVColumb);

        MyLVColumb.cx        = 125;
        MyLVColumb.pszText   = "Network Resource";
        MyLVColumb.iSubItem  = 1;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hLanViewListBox, 1, &MyLVColumb);

        MyLVColumb.cx        = 200;
        MyLVColumb.pszText   = "Host Name";
        MyLVColumb.iSubItem  = 2;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hLanViewListBox, 2, &MyLVColumb);

		MyLVColumb.cx        = 100;
        MyLVColumb.pszText   = "IP Address";
        MyLVColumb.iSubItem  = 3;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hLanViewListBox, 3, &MyLVColumb);

        MyLVColumb.cx        = 120;
        MyLVColumb.pszText   = "MAC Address";
        MyLVColumb.iSubItem  = 4;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hLanViewListBox, 4, &MyLVColumb);

        MyLVColumb.cx        = 140;
        MyLVColumb.pszText   = "Resource Comment";
        MyLVColumb.iSubItem  = 5;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hLanViewListBox, 5, &MyLVColumb);

        RECT WindowRECT;
        GetClientRect(hWnd, &WindowRECT);
        MoveWindow(hLanViewListBox, 0, 0, WindowRECT.right, WindowRECT.bottom - 21, TRUE);
        MoveWindow(hStatusBar, WindowRECT.right-20, WindowRECT.bottom-20, WindowRECT.right, WindowRECT.bottom, TRUE);

        char sSBText[255];

		sprintf_s(sSBText, sizeof(sSBText), "%d", 0);

		if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_SCANNING), 0, ScanDialog) != 1234)
            sprintf_s(sSBText, sizeof(sSBText), " Found %d Machine(s). Canceled.", giContainerCount);
        else sprintf_s(sSBText, sizeof(sSBText), " Found %d Machine(s).", giContainerCount);
		
        SendMessage(hStatusBar, (UINT)SB_SETTEXT, (WPARAM)0, (LPARAM)sSBText);

        CenterWindow(hWnd);

		return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE.
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_SIZE)
    {
        int nWidth  = LOWORD(lParam);
        int nHeight = HIWORD(lParam);

        MoveWindow(hLanViewListBox, 0, 0, nWidth, nHeight - 21, TRUE);
        MoveWindow(hStatusBar, nWidth-20, nHeight-20, nWidth, nHeight, TRUE);

        return TRUE;
    }

	//--------------------------------------------------------------------------

    if(uMsg == WM_COMMAND)
    {
        if(wParam == ID_FILE_EXIT) //- Cancel Button.
        {
            EndDialog(hWnd, 0);
            DestroyWindow(hWnd);

			hMainDialog = NULL;

            return TRUE;
        }

        if(LOWORD(wParam) == ID_HELP_ABOUT) //- About.
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = hWnd;

            NetLogo(&ADI);
            return TRUE;
        }
		
		return FALSE;
    }

    //--------------------------------------------------------------------------

	if(uMsg == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(hWnd, &ThisPS);

        //- Any painting should be done here.

        EndPaint(hWnd, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_SYSCOMMAND) //- Received a system menu message.
    {
        if(LOWORD(wParam) == MAINDIALOG_MENU_ABOUT) //- About.
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = hWnd;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_CLOSE) //- Received close message.
    {
        EndDialog(hWnd,0);
        DestroyWindow(hWnd);

		hMainDialog = NULL;

        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

